Imports System.Runtime.InteropServices

Public Interface IAdvancedMath
    Function Multiply(ByVal x As Integer, ByVal y As Integer) As Integer
    Function Divide(ByVal x As Integer, ByVal y As Integer) As Integer
End Interface

<ClassInterface(ClassInterfaceType.AutoDual)> _
Public Class VbNetCalc
    Implements IAdvancedMath

    Public Function Add(ByVal x As Integer, ByVal y As Integer)
        Return x + y
    End Function
    Public Function Subtract(ByVal x As Integer, ByVal y As Integer)
        Return x - y
    End Function

    ' ***** Implmentation de IAdvancedMath  ***** '
    Public Function Multiple(ByVal x As Integer, _
     ByVal y As Integer) As Integer Implements IAdvancedMath.Multiply
        Return x * y
    End Function

    Public Function Divide(ByVal x As Integer, _
     ByVal y As Integer) As Integer Implements IAdvancedMath.Divide
        If (y = 0) Then
            ' Intercepte comme un objet erreur COM.
            Throw New DivideByZeroException()
        End If
        Return x / y
    End Function
End Class

